import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Car is blocked': {
        _meta: {
            context: 'Signal name',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car is blocked',
        ru: 'Блокировка машины',
        cs: 'Vůz je zablokován',
    },
    'Dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dangerous ride',
        ru: 'Опасная поездка',
        cs: 'Nebezpečná jízda',
    },
    'Date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and time',
        ru: 'Дата и время',
        cs: 'Datum a čas',
    },
    Duration: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Duration',
        ru: 'Длительность',
        cs: 'Doba trvání',
    },
    'Inactivity: 1 hour': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Inactivity: 1 hour',
        ru: 'Простой: 1 час',
        cs: 'Neaktivní: 1 hodina',
    },
    'Leaving geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Leaving geofence',
        ru: 'Выезд из зоны',
        cs: 'Opuštění zóny',
    },
    Level: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Level',
        ru: 'Уровень',
        cs: 'Úroveň',
    },
    Ride: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Ride',
        ru: 'Поездка',
        cs: 'Jízda',
    },
    Signal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal',
        ru: 'Сигнал',
        cs: 'Signál',
    },
    'Telematics lag': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics lag',
        ru: 'Лаг телематики',
        cs: 'Zpoždění telematiky',
    },
    'Very dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Very dangerous ride',
        ru: 'Очень опасная поездка',
        cs: 'Velmi nebezpečná jízda',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
