import { RequestHelperConfigs, RequestHelperMethod } from '../../../request-helper/src';

enum REQUESTS {
    GET_SIGNALS = 'GET_SIGNALS',
    GET_CARS = 'GET_CARS',
    GET_SIGNALS_DESCRIPTIONS = 'GET_SIGNALS_DESCRIPTIONS',
    CHANGE_SIGNALS_ACTIVE = 'CHANGE_SIGNALS_ACTIVE',
    DELETE_SIGNAL = 'DELETE_SIGNAL',
}

const SIGNALS_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_SIGNALS]: {
        api: 'signals/list',
        cgiObj: {
            since: null,
            until: null,
            signals: null,
            actual_only: null,
            cars_ids: null,
            page_size: null,
            cars_cursor: null,
            sessions_cursor: null,
        },
    },
    [REQUESTS.GET_SIGNALS_DESCRIPTIONS]: {
        api: 'signals_descriptions/list',
    },
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            page_number: null,
            page_size: null,
            tags_filter: null,
            no_sh: null,
            no_mileage: null,
            sla: null,
            fines: null,
            cars_type: null,
            sensors: null,
            car_id: null,
            traits: null,
        },
    },
    [REQUESTS.CHANGE_SIGNALS_ACTIVE]: {
        api: 'signal/switch',
        method: RequestHelperMethod.POST,
    },
    [REQUESTS.DELETE_SIGNAL]: {
        api: 'signal/remove',
        method: RequestHelperMethod.POST,
    },
};

export { SIGNALS_REQUESTS, REQUESTS };
