export interface ISignal {
    is_actual: boolean;
    linked_entities: {
        entity_type: string;
        object_id: string;
        details?: any;
    }[];
    name: string;
    since: number;
    until?: number | null;
    details?: any;
}

enum SignalNames {
    leasing_car_is_blocked = 'leasing_car_is_blocked',
}

export interface ISignalDescriptionValue {
    display_name: string;
    name: SignalNames;
    is_editable?: boolean;
    is_enabled?: boolean;
    priority: 'normal' | 'warning' | 'critical';
}

export type ISignalDescription = Record<SignalNames, ISignalDescriptionValue>;

export interface ISignalsResponse {
    signals: ISignal[];
    signals_descriptions: ISignalDescription;
    meta?: string;
    can_get_more_pages: boolean;
    next_cars_cursor: number;
    next_sessions_cursor: number;
}

export interface FormattedSignal extends ISignal {
    description: ISignalDescriptionValue | null;
}

export type TableHeadersKeys = 'date_time' | 'level' | 'event' | 'car' | 'session' | 'duration';
