import React, { useState } from 'react';

import { DAYS_IN_MONTH, ONE_MONTH, ONE_SECOND } from 'constants/constants';

import { CharType, DashedLabel } from 'components/Informer';
import { buildScoringData } from 'components/Scoring/ScoringInformer/buildScoringData';
import { buildScoringMedianData } from 'components/Scoring/ScoringInformer/buildScoringMedianData';
import { ScoringInformer } from 'components/Scoring/ScoringInformer/ScoringInformer';
import { useScoringMedianData } from 'components/Scoring/ScoringInformer/useScoringMedianData';
import { useUserScoringData } from 'components/Users/UserScoringInformer/useUserScoringData';

export interface UserScoringInformerProps {
    userId?: string | null;
    type: CharType;
}

export const UserScoringInformer: React.FC<UserScoringInformerProps> = function UserScoringInformer({ userId, type }) {
    let [isLoading, , chart_data, getData] = useUserScoringData<any>({
        handler: (data) => {
            return buildScoringData(data?.records);
        },
    });

    let [, , chart_data_median, getMedianData] = useScoringMedianData<any>({
        handler: (data) => {
            return buildScoringMedianData(data);
        },
    });

    let [additionalHeaders, setAdditionalHeader] = useState<any[]>([]);

    React.useEffect(() => {
        if (userId) {
            let currentDate = Date.now();

            getData({
                since: Math.trunc((currentDate - ONE_MONTH) / ONE_SECOND),
                until: Math.trunc(currentDate / ONE_SECOND),
                object_id: userId,
                tags: 'scoring_user_tag',
            });

            getMedianData({
                user_id: userId,
                limit: DAYS_IN_MONTH,
            });

            setAdditionalHeader([<DashedLabel key={0} />]);
        }
    }, [userId]);

    return (
        <ScoringInformer
            chartData={chart_data}
            chartMedianData={chart_data_median}
            type={type}
            additionalHeaders={additionalHeaders}
            isLoading={!userId ? false : isLoading}
        />
    );
};
