import React, { MutableRefObject, useRef } from 'react';

import { REQUESTS, USERS_REQUESTS } from 'components/Users/request';

import { RequestHelper } from '../../../../request-helper/src';

interface UseUserScoringDataProps<T> {
    handler: (data?: any) => T | null;
}

export function useUserScoringData<T>({
    handler,
}: UseUserScoringDataProps<T>): [boolean, null | Error, T | null, (props) => void] {
    let [isLoading, setLoading] = React.useState(true);
    let [error, seError] = React.useState(null);
    let [data, setHistoryValues] = React.useState<any>([]);
    let retry = 0;

    const request: MutableRefObject<RequestHelper> = useRef(new RequestHelper({ requestConfigs: USERS_REQUESTS }));

    const getData = (queryParams) => {
        setLoading(true);
        request.current
            .exec(REQUESTS.GET_SCORING_HISTORY, { queryParams })
            .then((response) => {
                setHistoryValues(handler(response));
            })
            .catch((error) => {
                seError(error);

                if (!retry) {
                    getData(queryParams);
                    retry++;
                }
            })
            .finally(() => {
                setLoading(false);
            });
    };

    React.useEffect(() => {
        return () => {
            request.current.abort();
        };
    }, []);

    return [isLoading, error, data, getData];
}
