import { RequestHelperConfigs, RequestHelperMethod } from '../../../request-helper/src';

enum REQUESTS {
    GET_USERS = 'GET_USERS',
    ADD_USER = 'ADD_USER',
    EDIT_USER = 'EDIT_USER',
    DELETE_USER = 'DELETE_USER',
    SEARCH = 'SEARCH',
    GET_SCORING_HISTORY = 'GET_SCORING_HISTORY',
}

const USERS_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_USERS]: {
        method: RequestHelperMethod.POST,
        api: 'organization/members/list',
        cgiObj: {
            user_score: true,
        },
    },
    [REQUESTS.ADD_USER]: {
        method: RequestHelperMethod.POST,
        api: 'organization/driver/create',
    },
    [REQUESTS.EDIT_USER]: {
        method: RequestHelperMethod.POST,
        api: 'organization/member/edit',
    },
    [REQUESTS.DELETE_USER]: {
        api: 'organization/member/delete',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.SEARCH]: {
        api: 'search',
        cgiObj: {
            has_all_of: null,
            limit: null,
            what: null,
        },
    },
    [REQUESTS.GET_SCORING_HISTORY]: {
        api: 'user/tags_history',
        cgiObj: {
            object_id: null,
            since: null,
            until: null,
            tags: null,
        },
    },
};

export { USERS_REQUESTS, REQUESTS };
