import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'All signals will lose their connection to this zone.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'All signals will lose their connection to this zone.',
        ru: 'Все сигналы потеряют привязку к этой зоне',
        cs: 'Všechny signály ztratí spojení s touto zónou.',
    },
    'Are you sure you want to exit without saving the zone? All current changes will be lost.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Are you sure you want to exit without saving the zone? All current changes will be lost.',
        ru: 'Точно хотите выйти без сохранения зоны? Все текущие изменения сбросятся.',
        cs: 'Opravdu chcete ukončit aplikaci bez uložení zóny? Všechny aktuální změny budou ztraceny.',
    },
    Back: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Back',
        ru: 'Назад',
        cs: 'Zpět',
    },
    'Create geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create geofence',
        ru: 'Создать зону',
        cs: 'Vytvořit zónu',
    },
    'Delete geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete geofence',
        ru: 'Удалить зону',
        cs: 'Odstranit zónu',
    },
    'Geofence name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Geofence name',
        ru: 'Название зоны',
        cs: 'Název zóny',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
    'Unsaved changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unsaved changes',
        ru: 'Несохраненные изменения',
        cs: 'Neuložené změny',
    },
    'Yes, go back': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, go back',
        ru: 'Да, выйти',
        cs: 'Ano, přejít zpět',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
