import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Create geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create geofence',
        ru: 'Создать зону',
        cs: 'Vytvořit zónu',
    },
    'Failed to load geofences': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Failed to load geofences',
        ru: 'Не удалось загрузить зоны',
        cs: 'Načtení zón se nezdařilo',
    },
    'Geofence are needed to set up leaving or entry signals and control movement of drivers': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Geofence are needed to set up leaving or entry signals and control movement of drivers',
        ru: 'Зоны нужны, чтобы формировать сигналы выезда или въезда в зону и ограничивать перемещение водителей',
        cs: 'K nastavení signálů pro opuštění nebo vstup a k ovládání pohybu řidičů je zapotřebí ohraničení',
    },
    'There are currently no geofences': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'There are currently no geofences',
        ru: 'Сейчас зон нет',
        cs: 'Aktuálně nejsou žádná ohraničení',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
