import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Error while creating geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Error while creating geofence',
        ru: 'Ошибка при создании зоны',
        cs: 'Chyba při vytváření zóny',
    },
    'Signal Center': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal Center',
        ru: 'Сигнальный центр',
        cs: 'Signální centrum',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
