import { RequestHelperConfigs, RequestHelperMethod } from '../../../request-helper/src';

enum REQUESTS {
    GET_ZONES = 'GET_ZONES',
    ADD_ZONE = 'ADD_ZONE',
    REMOVE_ZONE = 'REMOVE_ZONE',
}

const ZONES_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_ZONES]: {
        api: 'zone/get',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.ADD_ZONE]: {
        api: 'zone/add',
        method: RequestHelperMethod.POST,
    },
    [REQUESTS.REMOVE_ZONE]: {
        api: 'zone/remove',
        method: RequestHelperMethod.POST,
    },
};

export { ZONES_REQUESTS, REQUESTS };
