import { CarStatusType } from 'entities/Car/consts/CarStatusType';

enum ITableValueType {
    PERCENT = 'percent',
    NUMERIC = 'numeric',
    MONEY = 'money',
    KILOMETERS = 'kilometers',
    HOURS = 'hours',
}

export default ITableValueType;

interface ILeasingStatsNumberItem {
    type: ITableValueType;
    value: number;
}

export interface ILeasingStats {
    utilization: ILeasingStatsNumberItem;
    sh: ILeasingStatsNumberItem;
    fresh_issue_date?: boolean;
}

export enum ModalObjectTypes {
    SESSION = 'session',
    SIGNAL = 'signal',
    USER = 'user',
    SEARCH = 'search',
    UPSERT_CAR = 'upsert_car',
    CAR_GROUP = 'car_group',
    ADD_SIGNAL = 'add_signal',
    ADD_USER = 'add_user',
    SIGNAL_SETTINGS = 'signal_settings',
}

export enum MetaControlTypes {
    clear = 'clear',
    save = 'save',
}

export { CarStatusType as StatusTypes };
