import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Forbidden to park': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Forbidden to park',
        ru: 'Недоступные для парковки',
        cs: 'Parkování zakázáno',
    },
    'Forbidden to ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Forbidden to ride',
        ru: 'Запрещенные для поездок',
        cs: 'Jízda zakázána',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
