import React, { useState } from 'react';

import { useOutsideClickHandler } from 'hooks/useOutsideClickHandler';

import { Areas, AreasWidget } from 'components/ui/Buttons/AreasButton/AreasWidget';
import Button from 'components/ui/Buttons/Button';

import { i18n } from 'components/ui/Buttons/AreasButton/index.i18n';

import AreasIcon from 'components/ui/Buttons/AreasButton/areas_icon.component.svg';

import style from 'components/ui/Buttons/AreasButton/index.css';

interface IAreasButtonProps {
    checked: { [key: string]: boolean };
    onCheck: (isForbiddenToRide: boolean, isForbiddenToPark: boolean) => void;
}

export const AreasButton = (props: IAreasButtonProps) => {
    let { onCheck: onCheckProps, checked } = props;

    const [isWidgetOpen, setIsWidgetOpen] = useState<boolean>(false);
    let widgetRef = React.useRef<HTMLDivElement | null>(null);
    let buttonRef = React.useRef<HTMLDivElement | null>(null);
    useOutsideClickHandler(widgetRef, (event) => {
        let isButtonClick = event.composedPath().some((node) => node?.isEqualNode?.(buttonRef?.current));
        let isWidgetClick = event.target.isEqualNode(widgetRef?.current);

        if (!(isWidgetClick || isButtonClick)) {
            onWidgetClose();
        }
    });

    const onWidgetOpen = () => {
        setIsWidgetOpen(!isWidgetOpen);
    };

    const onWidgetClose = () => {
        setIsWidgetOpen(false);
    };

    const onCheck = (value: { id: Areas; checked: boolean }[]) => {
        onCheckProps(
            value.find((item) => item.id === Areas.FORBIDDEN_TO_RIDE)?.checked ?? false,
            value.find((item) => item.id === Areas.FORBIDDEN_TO_PARK)?.checked ?? false,
        );
    };

    return (
        <div className={style.areas_button}>
            <div ref={buttonRef}>
                <Button
                    title={i18n('Geofences')}
                    iconComponent={<AreasIcon />}
                    onClick={onWidgetOpen}
                />
            </div>
            {isWidgetOpen ? (
                <AreasWidget
                    checked={checked}
                    onCheck={onCheck}
                    ref={widgetRef}
                />
            ) : null}
        </div>
    );
};
