import React, { ClassicElement } from 'react';

import { EMPTY_DATA } from 'constants/constants';

import style from 'components/ui/Buttons/Button/index.css';

export interface ICommonButtonProps {
    title: string | ClassicElement<any>;
    onClick: () => void;
    disabled?: boolean;
}

interface IButtonProps extends ICommonButtonProps {
    iconComponent?: any;
}

const Button = (props: IButtonProps) => {
    let { title, onClick, iconComponent, disabled } = props;

    return (
        <button
            disabled={disabled ?? false}
            className={`${style.button} ${disabled ? style.disabled : ''}`}
            onClick={onClick}
        >
            {iconComponent ? <div className={style.icon_container}>{iconComponent}</div> : null}
            {title || EMPTY_DATA}
        </button>
    );
};

export default Button;
