import * as React from 'react';
import { Story } from '@storybook/react';

import { ButtonPopup, IButtonPopupProps } from 'components/ui/Buttons/ButtonPopup/index';
import ControlButton, { ButtonSize } from 'components/ui/Buttons/ControlButton';

import styles from 'components/ui/Buttons/ButtonPopup/index.story.css';

export default { title: 'Button/ButtonPopup' };

const Template: Story<IButtonPopupProps> = (props) => (
    <div className={styles.position}>
        <ButtonPopup {...props} />
    </div>
);

export const _default_with_additional_button = Template.bind({});

_default_with_additional_button.args = {
    button: (onClick) => (
        <ControlButton
            onClick={onClick}
            title="test"
            size={ButtonSize.M}
            tertiary
            leftAlign
        />
    ),
    startOpen: true,
    contentContainer: () => <div className={styles.title_wrapper}>Тест тест тест тест</div>,
};

export const _default = Template.bind({});

_default.args = {
    button: (onClick) => (
        <ControlButton
            onClick={onClick}
            title="test"
        />
    ),
    startOpen: true,
    contentContainer: () => <div className={styles.title_wrapper}>Тест тест тест тест</div>,
};
