import * as React from 'react';

import { useOutsideClickHandler } from 'hooks/useOutsideClickHandler';

import styles from 'components/ui/Buttons/ButtonPopup/index.css';

export interface IButtonPopupProps {
    button: (onClick: Function) => React.ReactElement;
    contentContainer: (onClick: Function) => React.ReactElement;
    startOpen?: boolean;
}

export const ButtonPopup = (props: IButtonPopupProps) => {
    let { button, contentContainer, startOpen } = props;
    let [isPopupShowing, showPopup] = React.useState(startOpen ?? false);
    let containerRef = React.useRef<HTMLDivElement>(null);
    let popupRef = React.useRef<HTMLDivElement>(null);
    useOutsideClickHandler(containerRef, () => {
        showPopup(false);
    });

    return (
        <div
            ref={containerRef}
            className={styles.container}
        >
            <div
                ref={popupRef}
                className={`${styles.popup_container} ${isPopupShowing ? styles.popup_container_showing : ''}`}
            >
                {contentContainer(() => {
                    showPopup((prev) => !prev);
                })}
            </div>
            {button(() => {
                showPopup((prev) => !prev);
            })}
        </div>
    );
};
