import * as React from 'react';

import CommandButton from 'components/ui/Buttons/CommandButton/index';

const TITLE = 'Command Button Title';
const DESCRIPTION = 'Command Button Description Text';
const ON_CLICK = () => {};

export default { title: 'UI/CommandButton', component: CommandButton };
export const _empty_button = () => {
    return (
        <CommandButton
            title=""
            onClick={ON_CLICK}
        />
    );
};

export const _default_button = () => {
    return (
        <CommandButton
            title={TITLE}
            onClick={ON_CLICK}
        />
    );
};

export const _with_description = () => {
    return (
        <CommandButton
            title={TITLE}
            description={DESCRIPTION}
            onClick={ON_CLICK}
        />
    );
};

export const _disabled = () => {
    return (
        <CommandButton
            disabled
            title={TITLE}
            description={DESCRIPTION}
            onClick={ON_CLICK}
        />
    );
};

export const _critical = () => {
    return (
        <CommandButton
            critical
            title={TITLE}
            description={DESCRIPTION}
            onClick={ON_CLICK}
        />
    );
};

//Arrow
export const _with_arrow = () => {
    return (
        <CommandButton
            withArrow
            title={TITLE}
            onClick={ON_CLICK}
        />
    );
};

export const _with_description_and_with_arrow = () => {
    return (
        <CommandButton
            withArrow
            title={TITLE}
            description={DESCRIPTION}
            onClick={ON_CLICK}
        />
    );
};

export const _with_arrow_disabled = () => {
    return (
        <CommandButton
            withArrow
            disabled
            title={TITLE}
            description={DESCRIPTION}
            onClick={ON_CLICK}
        />
    );
};
