import React, { ClassicElement } from 'react';

import { EMPTY_DATA } from 'constants/constants';

import MainText3 from 'components/ui/Text/MainText3';
import Subhead1 from 'components/ui/Text/Subhead1';

import Arrow from 'components/ui/Buttons/CommandButton/arrow.component.svg';

import style from 'components/ui/Buttons/CommandButton/index.css';

export interface ICommonButtonProps {
    title: string | ClassicElement<any>;
    onClick?: () => void;
    disabled?: boolean;
}

interface ICommandButtonProps extends ICommonButtonProps {
    description?: string;
    withArrow?: boolean;
    critical?: boolean;
    control?: any;
}

const CommandButton = (props: ICommandButtonProps) => {
    let { title, onClick: onClickProps, disabled, description, withArrow, control, critical } = props;

    const onClick = () => {
        if (!disabled && onClickProps) {
            onClickProps();
        }
    };

    return (
        <>
            <div
                className={`${style.command_button} ${disabled ? style.disabled : ''} ${
                    onClickProps ? style.with_click : ''
                } ${critical ? style.critical : ''}`}
                onClick={onClick}
            >
                <div className={style.info}>
                    <Subhead1 className={style.title}>{title || EMPTY_DATA}</Subhead1>
                    {description ? <MainText3 className={style.description}>{description}</MainText3> : null}
                </div>
                {control ? (
                    <div className={style.control_container}>{control}</div>
                ) : withArrow ? (
                    <Arrow className={style.arrow} />
                ) : null}
            </div>
        </>
    );
};

export default CommandButton;
