import * as React from 'react';
import { Story } from '@storybook/react';

import { ICommonButtonProps } from 'components/ui/Buttons/Button';
import ControlButton, { ButtonSize } from 'components/ui/Buttons/ControlButton/index';

const TITLE = 'Button';

export default { title: 'Button/ControlButton' };
const TemplateLSize: Story<ICommonButtonProps> = (props) => (
    <ControlButton
        {...props}
        size={ButtonSize.L}
    />
);

export const Empty = TemplateLSize.bind({});
Empty.args = {
    title: '',
    onClick: () => {},
};

//Primary
export const Primary = TemplateLSize.bind({});
Primary.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryHovered = TemplateLSize.bind({});
PrimaryHovered.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryActive = TemplateLSize.bind({});
PrimaryActive.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryFocused = TemplateLSize.bind({});
PrimaryFocused.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryDisabled = TemplateLSize.bind({});
PrimaryDisabled.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryDisabledHovered = TemplateLSize.bind({});
PrimaryDisabledHovered.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryDisabledActive = TemplateLSize.bind({});
PrimaryDisabledActive.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryFullWidth = TemplateLSize.bind({});
PrimaryFullWidth.args = {
    title: TITLE,
    onClick: () => {},
    fullWidth: true,
};

export const PrimaryLeftAlign = TemplateLSize.bind({});
PrimaryLeftAlign.args = {
    title: TITLE,
    onClick: () => {},
    fullWidth: true,
    leftAlign: true,
};

PrimaryHovered.parameters = { pseudo: { hover: true } };
PrimaryActive.parameters = { pseudo: { active: true } };
PrimaryFocused.parameters = { pseudo: { focusVisible: true } };
PrimaryDisabledHovered.parameters = { pseudo: { hover: true } };
PrimaryDisabledActive.parameters = { pseudo: { active: true } };

//Secondary
export const Secondary = TemplateLSize.bind({});
Secondary.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryHovered = TemplateLSize.bind({});
SecondaryHovered.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryActive = TemplateLSize.bind({});
SecondaryActive.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryFocused = TemplateLSize.bind({});
SecondaryFocused.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryDisabled = TemplateLSize.bind({});
SecondaryDisabled.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryDisabledHovered = TemplateLSize.bind({});
SecondaryDisabledHovered.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryDisabledActive = TemplateLSize.bind({});
SecondaryDisabledActive.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryFullWidth = TemplateLSize.bind({});
SecondaryFullWidth.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
};

export const SecondaryLeftAlign = TemplateLSize.bind({});
SecondaryLeftAlign.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    leftAlign: true,
};

SecondaryHovered.parameters = { pseudo: { hover: true } };
SecondaryActive.parameters = { pseudo: { active: true } };
SecondaryFocused.parameters = { pseudo: { focusVisible: true } };
SecondaryDisabledHovered.parameters = { pseudo: { hover: true } };
SecondaryDisabledActive.parameters = { pseudo: { active: true } };

//Secondary Critical
export const SecondaryCritical = TemplateLSize.bind({});
SecondaryCritical.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalHovered = TemplateLSize.bind({});
SecondaryCriticalHovered.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalActive = TemplateLSize.bind({});
SecondaryCriticalActive.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalFocused = TemplateLSize.bind({});
SecondaryCriticalFocused.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalDisabled = TemplateLSize.bind({});
SecondaryCriticalDisabled.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalDisabledHovered = TemplateLSize.bind({});
SecondaryCriticalDisabledHovered.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalDisabledActive = TemplateLSize.bind({});
SecondaryCriticalDisabledActive.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalFullWidth = TemplateLSize.bind({});
SecondaryCriticalFullWidth.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    critical: true,
};

export const SecondaryCriticalLeftAlign = TemplateLSize.bind({});
SecondaryCriticalLeftAlign.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    leftAlign: true,
};

SecondaryCriticalHovered.parameters = { pseudo: { hover: true } };
SecondaryCriticalActive.parameters = { pseudo: { active: true } };
SecondaryCriticalFocused.parameters = { pseudo: { focusVisible: true } };
SecondaryCriticalDisabledHovered.parameters = { pseudo: { hover: true } };
SecondaryCriticalDisabledActive.parameters = { pseudo: { active: true } };

//Tertiary
export const Tertiary = TemplateLSize.bind({});
Tertiary.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryHovered = TemplateLSize.bind({});
TertiaryHovered.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryActive = TemplateLSize.bind({});
TertiaryActive.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryFocused = TemplateLSize.bind({});
TertiaryFocused.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryDisabled = TemplateLSize.bind({});
TertiaryDisabled.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryDisabledHovered = TemplateLSize.bind({});
TertiaryDisabledHovered.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryDisabledActive = TemplateLSize.bind({});
TertiaryDisabledActive.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryFullWidth = TemplateLSize.bind({});
TertiaryFullWidth.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    fullWidth: true,
};

export const TertiaryLeftAlign = TemplateLSize.bind({});
TertiaryLeftAlign.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    fullWidth: true,
    leftAlign: true,
};

TertiaryHovered.parameters = { pseudo: { hover: true } };
TertiaryActive.parameters = { pseudo: { active: true } };
TertiaryFocused.parameters = { pseudo: { focusVisible: true } };
TertiaryDisabledHovered.parameters = { pseudo: { hover: true } };
TertiaryDisabledActive.parameters = { pseudo: { active: true } };

//Shadow
export const Shadow = TemplateLSize.bind({});
Shadow.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowHovered = TemplateLSize.bind({});
ShadowHovered.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowActive = TemplateLSize.bind({});
ShadowActive.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowFocused = TemplateLSize.bind({});
ShadowFocused.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowDisabled = TemplateLSize.bind({});
ShadowDisabled.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowDisabledHovered = TemplateLSize.bind({});
ShadowDisabledHovered.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowDisabledActive = TemplateLSize.bind({});
ShadowDisabledActive.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowFullWidth = TemplateLSize.bind({});
ShadowFullWidth.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    fullWidth: true,
};

export const ShadowLeftAlign = TemplateLSize.bind({});
ShadowLeftAlign.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    fullWidth: true,
    leftAlign: true,
};

ShadowHovered.parameters = { pseudo: { hover: true } };
ShadowActive.parameters = { pseudo: { active: true } };
ShadowFocused.parameters = { pseudo: { focusVisible: true } };
ShadowDisabledHovered.parameters = { pseudo: { hover: true } };
ShadowDisabledActive.parameters = { pseudo: { active: true } };

const TemplateMSize: Story<ICommonButtonProps> = (props) => (
    <ControlButton
        {...props}
        size={ButtonSize.M}
    />
);

export const EmptyMSize = TemplateMSize.bind({});
EmptyMSize.args = {
    title: '',
    onClick: () => {},
};

//Primary
export const PrimaryMSize = TemplateMSize.bind({});
PrimaryMSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryHoveredMSize = TemplateMSize.bind({});
PrimaryHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryActiveMSize = TemplateMSize.bind({});
PrimaryActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryFocusedMSize = TemplateMSize.bind({});
PrimaryFocusedMSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryDisabledMSize = TemplateMSize.bind({});
PrimaryDisabledMSize.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryDisabledHoveredMSize = TemplateMSize.bind({});
PrimaryDisabledHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryDisabledActiveMSize = TemplateMSize.bind({});
PrimaryDisabledActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryFullWidthMSize = TemplateMSize.bind({});
PrimaryFullWidthMSize.args = {
    title: TITLE,
    onClick: () => {},
    fullWidth: true,
};

export const PrimaryLeftAlignMSize = TemplateMSize.bind({});
PrimaryLeftAlignMSize.args = {
    title: TITLE,
    onClick: () => {},
    fullWidth: true,
    leftAlign: true,
};

PrimaryHoveredMSize.parameters = { pseudo: { hover: true } };
PrimaryActiveMSize.parameters = { pseudo: { active: true } };
PrimaryFocusedMSize.parameters = { pseudo: { focusVisible: true } };
PrimaryDisabledHoveredMSize.parameters = { pseudo: { hover: true } };
PrimaryDisabledActiveMSize.parameters = { pseudo: { active: true } };

//Secondary
export const SecondaryMSize = TemplateMSize.bind({});
SecondaryMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryHoveredMSize = TemplateMSize.bind({});
SecondaryHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryActiveMSize = TemplateMSize.bind({});
SecondaryActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryFocusedMSize = TemplateMSize.bind({});
SecondaryFocusedMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryDisabledMSize = TemplateMSize.bind({});
SecondaryDisabledMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryDisabledHoveredMSize = TemplateMSize.bind({});
SecondaryDisabledHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryDisabledActiveMSize = TemplateMSize.bind({});
SecondaryDisabledActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryFullWidthMSize = TemplateMSize.bind({});
SecondaryFullWidthMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
};

export const SecondaryLeftAlignMSize = TemplateMSize.bind({});
SecondaryLeftAlignMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    leftAlign: true,
};

SecondaryHoveredMSize.parameters = { pseudo: { hover: true } };
SecondaryActiveMSize.parameters = { pseudo: { active: true } };
SecondaryFocusedMSize.parameters = { pseudo: { focusVisible: true } };
SecondaryDisabledHoveredMSize.parameters = { pseudo: { hover: true } };
SecondaryDisabledActiveMSize.parameters = { pseudo: { active: true } };

//Secondary Critical
export const SecondaryCriticalMSize = TemplateMSize.bind({});
SecondaryCriticalMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalHoveredMSize = TemplateMSize.bind({});
SecondaryCriticalHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalActiveMSize = TemplateMSize.bind({});
SecondaryCriticalActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalFocusedMSize = TemplateMSize.bind({});
SecondaryCriticalFocusedMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalDisabledMSize = TemplateMSize.bind({});
SecondaryCriticalDisabledMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalDisabledHoveredMSize = TemplateMSize.bind({});
SecondaryCriticalDisabledHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalDisabledActiveMSize = TemplateMSize.bind({});
SecondaryCriticalDisabledActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalFullWidthMSize = TemplateMSize.bind({});
SecondaryCriticalFullWidthMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    critical: true,
};

export const SecondaryCriticalLeftAlignMSize = TemplateMSize.bind({});
SecondaryCriticalLeftAlignMSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    leftAlign: true,
};

SecondaryCriticalHoveredMSize.parameters = { pseudo: { hover: true } };
SecondaryCriticalActiveMSize.parameters = { pseudo: { active: true } };
SecondaryCriticalFocusedMSize.parameters = { pseudo: { focusVisible: true } };
SecondaryCriticalDisabledHoveredMSize.parameters = { pseudo: { hover: true } };
SecondaryCriticalDisabledActiveMSize.parameters = { pseudo: { active: true } };

//Tertiary
export const TertiaryMSize = TemplateMSize.bind({});
TertiaryMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryHoveredMSize = TemplateMSize.bind({});
TertiaryHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryActiveMSize = TemplateMSize.bind({});
TertiaryActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryFocusedMSize = TemplateMSize.bind({});
TertiaryFocusedMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryDisabledMSize = TemplateMSize.bind({});
TertiaryDisabledMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryDisabledHoveredMSize = TemplateMSize.bind({});
TertiaryDisabledHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryDisabledActiveMSize = TemplateMSize.bind({});
TertiaryDisabledActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryFullWidthMSize = TemplateMSize.bind({});
TertiaryFullWidthMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    fullWidth: true,
};

export const TertiaryLeftAlignMSize = TemplateMSize.bind({});
TertiaryLeftAlignMSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    fullWidth: true,
    leftAlign: true,
};

TertiaryHoveredMSize.parameters = { pseudo: { hover: true } };
TertiaryActiveMSize.parameters = { pseudo: { active: true } };
TertiaryFocusedMSize.parameters = { pseudo: { focusVisible: true } };
TertiaryDisabledHoveredMSize.parameters = { pseudo: { hover: true } };
TertiaryDisabledActiveMSize.parameters = { pseudo: { active: true } };

//Shadow
export const ShadowMSize = TemplateMSize.bind({});
ShadowMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowHoveredMSize = TemplateMSize.bind({});
ShadowHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowActiveMSize = TemplateMSize.bind({});
ShadowActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowFocusedMSize = TemplateMSize.bind({});
ShadowFocusedMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowDisabledMSize = TemplateMSize.bind({});
ShadowDisabledMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowDisabledHoveredMSize = TemplateMSize.bind({});
ShadowDisabledHoveredMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowDisabledActiveMSize = TemplateMSize.bind({});
ShadowDisabledActiveMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowFullWidthMSize = TemplateMSize.bind({});
ShadowFullWidthMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    fullWidth: true,
};

export const ShadowLeftAlignMSize = TemplateMSize.bind({});
ShadowLeftAlignMSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    fullWidth: true,
    leftAlign: true,
};

ShadowHoveredMSize.parameters = { pseudo: { hover: true } };
ShadowActiveMSize.parameters = { pseudo: { active: true } };
ShadowFocusedMSize.parameters = { pseudo: { focusVisible: true } };
ShadowDisabledHoveredMSize.parameters = { pseudo: { hover: true } };
ShadowDisabledActiveMSize.parameters = { pseudo: { active: true } };

const TemplateSSize: Story<ICommonButtonProps> = (props) => (
    <ControlButton
        {...props}
        size={ButtonSize.S}
    />
);

export const EmptySSize = TemplateSSize.bind({});
EmptySSize.args = {
    title: '',
    onClick: () => {},
};

//Primary
export const PrimarySSize = TemplateSSize.bind({});
PrimarySSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryHoveredSSize = TemplateSSize.bind({});
PrimaryHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryActiveSSize = TemplateSSize.bind({});
PrimaryActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryFocusedSSize = TemplateSSize.bind({});
PrimaryFocusedSSize.args = {
    title: TITLE,
    onClick: () => {},
};

export const PrimaryDisabledSSize = TemplateSSize.bind({});
PrimaryDisabledSSize.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryDisabledHoveredSSize = TemplateSSize.bind({});
PrimaryDisabledHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryDisabledActiveSSize = TemplateSSize.bind({});
PrimaryDisabledActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    disabled: true,
};

export const PrimaryFullWidthSSize = TemplateSSize.bind({});
PrimaryFullWidthSSize.args = {
    title: TITLE,
    onClick: () => {},
    fullWidth: true,
};

export const PrimaryLeftAlignSSize = TemplateSSize.bind({});
PrimaryLeftAlignSSize.args = {
    title: TITLE,
    onClick: () => {},
    fullWidth: true,
    leftAlign: true,
};

PrimaryHoveredSSize.parameters = { pseudo: { hover: true } };
PrimaryActiveSSize.parameters = { pseudo: { active: true } };
PrimaryFocusedSSize.parameters = { pseudo: { focusVisible: true } };
PrimaryDisabledHoveredSSize.parameters = { pseudo: { hover: true } };
PrimaryDisabledActiveSSize.parameters = { pseudo: { active: true } };

//Secondary
export const SecondarySSize = TemplateSSize.bind({});
SecondarySSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryHoveredSSize = TemplateSSize.bind({});
SecondaryHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryActiveSSize = TemplateSSize.bind({});
SecondaryActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryFocusedSSize = TemplateSSize.bind({});
SecondaryFocusedSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
};

export const SecondaryDisabledSSize = TemplateSSize.bind({});
SecondaryDisabledSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryDisabledHoveredSSize = TemplateSSize.bind({});
SecondaryDisabledHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryDisabledActiveSSize = TemplateSSize.bind({});
SecondaryDisabledActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
};

export const SecondaryFullWidthSSize = TemplateSSize.bind({});
SecondaryFullWidthSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
};

export const SecondaryLeftAlignSSize = TemplateSSize.bind({});
SecondaryLeftAlignSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    leftAlign: true,
};

SecondaryHoveredSSize.parameters = { pseudo: { hover: true } };
SecondaryActiveSSize.parameters = { pseudo: { active: true } };
SecondaryFocusedSSize.parameters = { pseudo: { focusVisible: true } };
SecondaryDisabledHoveredSSize.parameters = { pseudo: { hover: true } };
SecondaryDisabledActiveSSize.parameters = { pseudo: { active: true } };

//Secondary Critical
export const SecondaryCriticalSSize = TemplateSSize.bind({});
SecondaryCriticalSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalHoveredSSize = TemplateSSize.bind({});
SecondaryCriticalHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalActiveSSize = TemplateSSize.bind({});
SecondaryCriticalActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalFocusedSSize = TemplateSSize.bind({});
SecondaryCriticalFocusedSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    critical: true,
};

export const SecondaryCriticalDisabledSSize = TemplateSSize.bind({});
SecondaryCriticalDisabledSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalDisabledHoveredSSize = TemplateSSize.bind({});
SecondaryCriticalDisabledHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalDisabledActiveSSize = TemplateSSize.bind({});
SecondaryCriticalDisabledActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    disabled: true,
    critical: true,
};

export const SecondaryCriticalFullWidthSSize = TemplateSSize.bind({});
SecondaryCriticalFullWidthSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    critical: true,
};

export const SecondaryCriticalLeftAlignSSize = TemplateSSize.bind({});
SecondaryCriticalLeftAlignSSize.args = {
    title: TITLE,
    onClick: () => {},
    secondary: true,
    fullWidth: true,
    leftAlign: true,
};

SecondaryCriticalHoveredSSize.parameters = { pseudo: { hover: true } };
SecondaryCriticalActiveSSize.parameters = { pseudo: { active: true } };
SecondaryCriticalFocusedSSize.parameters = { pseudo: { focusVisible: true } };
SecondaryCriticalDisabledHoveredSSize.parameters = { pseudo: { hover: true } };
SecondaryCriticalDisabledActiveSSize.parameters = { pseudo: { active: true } };

//Tertiary
export const TertiarySSize = TemplateSSize.bind({});
TertiarySSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryHoveredSSize = TemplateSSize.bind({});
TertiaryHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryActiveSSize = TemplateSSize.bind({});
TertiaryActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryFocusedSSize = TemplateSSize.bind({});
TertiaryFocusedSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
};

export const TertiaryDisabledSSize = TemplateSSize.bind({});
TertiaryDisabledSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryDisabledHoveredSSize = TemplateSSize.bind({});
TertiaryDisabledHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryDisabledActiveSSize = TemplateSSize.bind({});
TertiaryDisabledActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    disabled: true,
};

export const TertiaryFullWidthSSize = TemplateSSize.bind({});
TertiaryFullWidthSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    fullWidth: true,
};

export const TertiaryLeftAlignSSize = TemplateSSize.bind({});
TertiaryLeftAlignSSize.args = {
    title: TITLE,
    onClick: () => {},
    tertiary: true,
    fullWidth: true,
    leftAlign: true,
};

TertiaryHoveredSSize.parameters = { pseudo: { hover: true } };
TertiaryActiveSSize.parameters = { pseudo: { active: true } };
TertiaryFocusedSSize.parameters = { pseudo: { focusVisible: true } };
TertiaryDisabledHoveredSSize.parameters = { pseudo: { hover: true } };
TertiaryDisabledActiveSSize.parameters = { pseudo: { active: true } };

//Shadow
export const ShadowSSize = TemplateSSize.bind({});
ShadowSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowHoveredSSize = TemplateSSize.bind({});
ShadowHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowActiveSSize = TemplateSSize.bind({});
ShadowActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowFocusedSSize = TemplateSSize.bind({});
ShadowFocusedSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
};

export const ShadowDisabledSSize = TemplateSSize.bind({});
ShadowDisabledSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowDisabledHoveredSSize = TemplateSSize.bind({});
ShadowDisabledHoveredSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowDisabledActiveSSize = TemplateSSize.bind({});
ShadowDisabledActiveSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    disabled: true,
};

export const ShadowFullWidthSSize = TemplateSSize.bind({});
ShadowFullWidthSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    fullWidth: true,
};

export const ShadowLeftAlignSSize = TemplateSSize.bind({});
ShadowLeftAlignSSize.args = {
    title: TITLE,
    onClick: () => {},
    shadow: true,
    fullWidth: true,
    leftAlign: true,
};

ShadowHoveredSSize.parameters = { pseudo: { hover: true } };
ShadowActiveSSize.parameters = { pseudo: { active: true } };
ShadowFocusedSSize.parameters = { pseudo: { focusVisible: true } };
ShadowDisabledHoveredSSize.parameters = { pseudo: { hover: true } };
ShadowDisabledActiveSSize.parameters = { pseudo: { active: true } };
