import * as React from 'react';
import { Story } from '@storybook/react';

import { IStackedButtonsProps, StackedButtons } from 'components/ui/Buttons/StackedButtons/index';
import { StackOrientation } from 'components/ui/Buttons/StackedButtons/types';

import StoryIcon from 'components/ui/Buttons/StackedButtons/story.component.svg';

export default { title: 'Button/Stacked' };

const Template: Story<IStackedButtonsProps> = (props) => <StackedButtons {...props} />;

export const _3_buttons_horizontal = Template.bind({});
_3_buttons_horizontal.args = {
    buttons: [
        { icon: <StoryIcon />, onClick: () => undefined, active: true },
        { icon: <StoryIcon />, onClick: () => undefined },
        { icon: <StoryIcon />, onClick: () => undefined },
    ],
};

export const _3_buttons_vertical = Template.bind({});
_3_buttons_vertical.args = {
    buttons: [
        { icon: <StoryIcon />, onClick: () => undefined },
        { icon: <StoryIcon />, onClick: () => undefined },
        { icon: <StoryIcon />, onClick: () => undefined },
    ],
    orientation: StackOrientation.VERTICAL,
};
