import * as React from 'react';
import { Story } from '@storybook/react';

import Card, { ICardProps } from 'components/ui/Card/index';

import EditIcon from 'components/ui/Card/edit.component.svg';

export default { title: 'UI/Card' };
const Template: Story<ICardProps> = (props) => <Card {...props} />;

export const OnlyEmptyName = Template.bind({});
OnlyEmptyName.args = {
    name: '',
};

export const OnlyName = Template.bind({});
OnlyName.args = {
    name: 'Card name',
};

export const WithLabel = Template.bind({});
WithLabel.args = {
    name: 'Card name',
    labels: ['label 1'],
};

export const WithDescription = Template.bind({});
WithDescription.args = {
    name: 'Card name',
    description: 'Card description',
};

export const WithLabelAndDescription = Template.bind({});
WithLabelAndDescription.args = {
    name: 'Card name',
    labels: ['label 1'],
    description: 'Card description',
};

export const WithLongNameLabelsAndDescription = Template.bind({});
WithLongNameLabelsAndDescription.args = {
    labels: ['Long label 1', 'Long label 2', 'Long label 3', 'Long label 4', 'Long label 5'],
    name: 'Very very very very very long report name',
    description:
        'Very very very very very very very very very very very very very very very very very very very very very very very very very long report description',
};

export const WithIcon = Template.bind({});
WithIcon.args = {
    name: 'Card name',
    labels: ['label 1'],
    description: 'Card description',
    icons: [
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
    ],
};

export const WithIcons = Template.bind({});
WithIcons.args = {
    name: 'Card name',
    labels: ['label 1'],
    description: 'Card description',
    icons: [
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
    ],
};

export const WithIconsAndLongName = Template.bind({});
WithIconsAndLongName.args = {
    name: 'Very very very very very long report name',
    labels: ['label 1'],
    description: 'Card description',
    icons: [
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
        {
            icon: <EditIcon />,
            onClick: () => {},
        },
    ],
};

export const Hovered = Template.bind({});
Hovered.args = {
    name: 'Card name',
    labels: ['label 1'],
    description: 'Card description',
};

Hovered.parameters = { pseudo: { hover: true } };
WithIcon.parameters = { pseudo: { hover: true } };
WithIcons.parameters = { pseudo: { hover: true } };
WithIconsAndLongName.parameters = { pseudo: { hover: true } };
