import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import style from 'components/ui/Card/index.css';

export interface ICardProps {
    name: string;
    labels?: string[];
    description?: string;
    onClick?: () => void;
    icons?: {
        icon: any;
        onClick?: () => void;
    }[];
}

const Card = ({ name, labels, description, onClick, icons }: ICardProps) => {
    const onControlClick = (controlClickCallback: any, event: any) => {
        event.stopPropagation();
        controlClickCallback();
    };

    return (
        <>
            <div
                className={style.card}
                onClick={onClick}
            >
                <div className={style.card_name}>
                    <div
                        title={name}
                        className={style.name}
                    >
                        {name || EMPTY_DATA}
                    </div>
                    {icons?.length ? (
                        <div className={style.controls_container}>
                            {icons.map((iconItem, index) => {
                                let { icon, onClick: onIconClick } = iconItem;

                                return (
                                    <div
                                        key={index}
                                        className={style.control}
                                        onClick={onControlClick.bind(null, onIconClick)}
                                    >
                                        {icon}
                                    </div>
                                );
                            })}
                        </div>
                    ) : null}
                </div>
                {labels?.length || description ? (
                    <div className={style.card_info}>
                        {labels?.length ? (
                            <div className={style.labels_container}>
                                {labels.map((label) => {
                                    return (
                                        <div
                                            key={label}
                                            className={style.card_label}
                                            title={label || EMPTY_DATA}
                                        >
                                            {label || EMPTY_DATA}
                                        </div>
                                    );
                                })}
                            </div>
                        ) : null}
                        {description ? (
                            <div
                                title={description ?? ''}
                                className={style.card_description}
                            >
                                {description}
                            </div>
                        ) : null}
                    </div>
                ) : null}
            </div>
        </>
    );
};

export default Card;
