import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    No: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'No',
        ru: 'Нет',
        cs: 'Ne',
    },
    Yes: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Yes',
        ru: 'Да',
        cs: 'Ano',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
