import * as React from 'react';

import Confirm from 'components/ui/Confirm/index';
import Header1 from 'components/ui/Text/Header1';

const CONFIRM_TITLE = 'Confirm Title';
const DESCRIPTION_TEXT = 'Are you sure?';
const ON_CONFIRM = () => {};

export default { title: 'UI/Confirm', component: Confirm };
export const _default_confirm = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
        />
    );
};

export const _text_description = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            description={DESCRIPTION_TEXT}
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
        />
    );
};

export const _component_description = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            description={<Header1>{DESCRIPTION_TEXT}</Header1>}
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
        />
    );
};

export const _empty_button_titles = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            confirmButtonTitle=""
            closeButtonTitle=""
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
        />
    );
};

export const _custom_confirm_button_title = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            confirmButtonTitle={`Yes, let's do it!`}
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
        />
    );
};

export const _custom_close_button_title = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            closeButtonTitle="No, close this confirm!"
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
        />
    );
};

export const _loading = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
            isLoading={true}
        />
    );
};

export const _error = () => {
    return (
        <Confirm
            title={CONFIRM_TITLE}
            onConfirm={ON_CONFIRM}
            onClose={ON_CONFIRM}
            error={new Error()}
        />
    );
};
