import React from 'react';

import ControlButton from 'components/ui/Buttons/ControlButton';
import ErrorLabel from 'components/ui/ErrorLabel';
import { Modal } from 'components/ui/Modal';

import { i18n } from 'components/ui/Confirm/index.i18n';

import style from 'components/ui/Confirm/index.css';

interface IConfirmProps {
    title: string;
    description?: any;
    confirmButtonTitle?: string;
    closeButtonTitle?: string;
    onConfirm: () => void;
    onClose: () => void;
    isLoading?: boolean;
    error?: Error | null;
}

const Confirm = ({
    title,
    description,
    confirmButtonTitle,
    closeButtonTitle,
    onConfirm,
    onClose,
    isLoading,
    error,
}: IConfirmProps) => {
    return (
        <Modal
            onClose={onClose}
            title={title}
            contentComponent={
                <>
                    {description ? <div className={style.description}>{description}</div> : null}
                    <div className={style.buttons_container}>
                        {error ? (
                            <div className={style.error_label_container}>
                                <ErrorLabel
                                    simple
                                    className={style.error_label}
                                />
                            </div>
                        ) : null}
                        <ControlButton
                            title={confirmButtonTitle || i18n('Yes')}
                            isLoading={isLoading}
                            onClick={onConfirm}
                        />

                        <ControlButton
                            title={closeButtonTitle || i18n('No')}
                            disabled={isLoading}
                            tertiary
                            onClick={onClose}
                        />
                    </div>
                </>
            }
        />
    );
};

export default Confirm;
