import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import DescriptionIcon from 'components/ui/DescriptionIcon';
import { ScoringLabel, ScoringLabelTypes } from 'components/ui/ScoringLabel';

import style from 'components/ui/DashboardScoringLabel/index.css';

export const DEFAULT_SCORING_TITLE = 'Общий скоринг';
const GOOD_SCORE_LOW_BORDER = 4;
const NORMAL_SCORE_LOW_BORDER = 3;

interface IDashboardScoringLabelProps {
    title?: string;
    score: number | null;
}

class DashboardScoringLabel extends React.Component<IDashboardScoringLabelProps, any> {
    render() {
        let { title, score } = this.props;

        let titleDisplay = title ? title.toUpperCase() : DEFAULT_SCORING_TITLE.toUpperCase();
        let scoreDisplay = score !== null && score !== undefined ? score.toFixed(1).replace('.', ',') : EMPTY_DATA;

        let scoringTypeClass: ScoringLabelTypes;
        if (score !== null && score >= GOOD_SCORE_LOW_BORDER) {
            scoringTypeClass = ScoringLabelTypes.positive;
        } else if (score !== null && score >= NORMAL_SCORE_LOW_BORDER) {
            scoringTypeClass = ScoringLabelTypes.warning;
        } else if (score !== null) {
            scoringTypeClass = ScoringLabelTypes.negative;
        } else {
            scoringTypeClass = ScoringLabelTypes.unknown;
        }

        return (
            <div className={style.scoring_label_container}>
                <ScoringLabel
                    title={titleDisplay}
                    type={scoringTypeClass}
                    score={scoreDisplay}
                />
                <DescriptionIcon
                    description={
                        <div>
                            <div className={style.main}>Средний показатель благосостояния машин в портфеле.</div>
                            <div className={style.main}>Уровни риска:</div>
                            <div className={style.row}>
                                <span className={style.score_value}>1</span>
                                <span> - </span>
                                <span className={style.score_desc}>просрочка больше 30 дней</span>
                            </div>
                            <div className={style.row}>
                                <span className={style.score_value}>2</span>
                                <span> - </span>
                                <span className={style.score_desc}>просрочка больше 15 дней</span>
                            </div>
                            <div className={style.row}>
                                <span className={style.score_value}>3</span>
                                <span> - </span>
                                <span className={style.score_desc}>просрочка больше 5 дней</span>
                            </div>
                            <div className={style.row}>
                                <span className={style.score_value}>4</span>
                                <span> - </span>
                                <span className={style.score_desc}>оплата в срок</span>
                            </div>
                            <div className={style.row}>
                                <span className={style.score_value}>5</span>
                                <span> - </span>
                                <span className={style.score_desc}>показатель исключительной эффективности</span>
                            </div>
                        </div>
                    }
                />
            </div>
        );
    }
}

export default DashboardScoringLabel;
