import React, { useContext } from 'react';

import GlobalTooltipContext from 'contexts/GlobalTooltipContext';

import { useTooltipMouseHandler } from 'hooks/useTooltipMouseHandler';

import style from 'components/ui/DescriptionIcon/index.css';

export enum Direction {
    LEFT = 'left',
    RIGHT = 'right',
    TOP = 'top',
    BOTTOM = 'bottom',
}

interface IDescriptionIconProps {
    description: any;
    direction?: Direction;
    small?: boolean;
}

const DescriptionIcon = (props: IDescriptionIconProps) => {
    let { description, direction = Direction.RIGHT, small } = props;
    let iconRef = React.useRef<HTMLDivElement | null>(null);
    useTooltipMouseHandler(iconRef);

    const { setShow, setTooltipOptions } = useContext(GlobalTooltipContext);

    const onMouseEnter = () => {
        if (description) {
            setShow(true);
            setTooltipOptions({ title: description, direction, small });
        }
    };

    return (
        <div className={style.desc_icon_container}>
            <div
                className={style.desc_icon}
                onMouseEnter={onMouseEnter}
                ref={iconRef}
            />
        </div>
    );
};

export default DescriptionIcon;
