import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    h: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'h',
        ru: 'ч',
        cs: 'h',
    },
    min: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'min',
        ru: 'мин',
        cs: 'min',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
