import React from 'react';

import { ONE_MINUTE, SECONDS_IN_MINUTE } from 'constants/constants';

import { i18n } from 'components/ui/DurationUTCBetween/index.i18n';

export const getFormattedDuration = (duration: number) => {
    let full_minutes = duration / ONE_MINUTE;
    let minutes = Math.ceil(full_minutes);
    let hours = 0;
    if (minutes > SECONDS_IN_MINUTE) {
        let full_hours = minutes / SECONDS_IN_MINUTE;
        hours = Math.trunc(full_hours);
        minutes = Math.ceil((full_hours - hours) * SECONDS_IN_MINUTE);
    }
    if (full_minutes < 1) {
        return `< 1 ${i18n('min')}`;
    }

    return `${hours ? ` ${hours}${i18n('h')} ` : ''}${minutes} ${i18n('min')}`;
};

export const DurationUTCBetween = (props: { duration: number }) => {
    return <>{getFormattedDuration(props.duration)}</>;
};
