import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Loading error': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Loading error',
        ru: 'Ошибка при загрузке',
        cs: 'Chyba načítání',
    },
    Reload: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Reload',
        ru: 'Перезагрузить',
        cs: 'Znovu načíst',
    },
    "Try to reload the page, if it doesn't help - try to come back later": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "Try to reload the page, if it doesn't help - try to come back later",
        ru: 'Попробуйте перезагрузить страницу, если не поможет — попробуйте зайти попозже',
        cs: 'Zkuste stránku znovu načíst, a pokud to nepomůže, zkuste se vrátit později',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
