import React from 'react';

import { i18n } from 'components/ui/ErrorLabel/ErrorReloadLabel/index.i18n';

import ReloadIcon from 'components/ui/ErrorLabel/ErrorReloadLabel/reload.component.svg';

import style from 'components/ui/ErrorLabel/ErrorReloadLabel/index.css';

interface IErrorReloadLabelProps {
    title?: string;
    advice?: string;
    reloadTitle?: string;
    reloadFunction?: () => void;
    withoutIcon?: boolean;
}

const ErrorReloadLabel = ({ title, advice, reloadTitle, reloadFunction, withoutIcon }: IErrorReloadLabelProps) => {
    return (
        <div className={style.error_reload_label}>
            <div className={style.title}>{title ?? i18n('Loading error')}</div>
            <div className={style.advice}>
                {advice ?? i18n("Try to reload the page, if it doesn't help - try to come back later")}
            </div>
            {reloadFunction ? (
                <div
                    className={style.reload}
                    onClick={reloadFunction}
                >
                    {!withoutIcon ? <ReloadIcon /> : null}
                    <span>{reloadTitle ?? i18n('Reload')}</span>
                </div>
            ) : null}
        </div>
    );
};

export default ErrorReloadLabel;
