import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'An error occurred, please try again': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'An error occurred, please try again',
        ru: 'Произошла ошибка, попробуйте снова',
        cs: 'Došlo k chybě, zkuste to znovu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
