import React from 'react';

import { i18n } from 'components/ui/ErrorLabel/index.i18n';

import style from 'components/ui/ErrorLabel/index.css';

interface IErrorLabelProps {
    title?: string;
    simple?: boolean;
    className?: string;
}

const ErrorLabel = (props: IErrorLabelProps) => {
    const DEFAULT_TITLE = i18n('An error occurred, please try again');

    let { title, simple, className } = props;

    return (
        <div className={`${style.error_label} ${simple ? style.simple : ''} ${className ?? ''}`}>
            {title || DEFAULT_TITLE}
        </div>
    );
};

export default ErrorLabel;
