import React from 'react';

import Tooltip, { ITooltipProps } from 'components/ui/Tooltip';

import style from 'components/ui/GlobalTooltip/index.css';

export interface IGlobalTooltipProps {
    show: boolean;
    elementPosition: [number | null, number | null];
    elementSize: [number | null, number | null];
    tooltipOptions: ITooltipProps | null;
}

const GlobalTooltip = (props: IGlobalTooltipProps) => {
    let { show, elementPosition, elementSize, tooltipOptions } = props;
    let [top, left] = elementPosition;
    let [width, height] = elementSize;

    let { title, small, direction } = tooltipOptions ?? {};

    return show ? (
        <div
            className={style.global_tooltip}
            style={{
                top: `${top ?? null}px`,
                left: `${left ?? null}px`,
                width: `${width ?? null}px`,
                height: `${height ?? null}px`,
            }}
        >
            <Tooltip
                title={title ?? ''}
                small={small}
                direction={direction}
            />
        </div>
    ) : null;
};

export default GlobalTooltip;
