import * as React from 'react';

import Image from 'components/ui/Image/index';
import NoPhotos from 'components/ui/Image/NoPhotos';

export default { title: 'UI/Image', component: Image };

const Template = (props) => {
    return <Image {...props} />;
};

const url_landscape = 'https://carsharing.s3.yandex.net/subscription/gallery/rapid_w_photo_01.jpeg';
const url_portrait = 'https://carsharing.s3.yandex.net/subscription/gallery/duster_photo_08.png';

export const _default_empty = Template.bind({}, { src: '' });
export const _default_with_src = Template.bind({}, { src: url_landscape });

export const images = () => {
    return (
        <div style={{ display: 'flex', gap: '25px' }}>
            <Image src="" />
            <Image
                src=""
                withError
            />
            <Image src={url_landscape} />
            <Image src={url_portrait} />
        </div>
    );
};

export const no_photos = () => {
    return (
        <div style={{ width: '300px', outline: '1px dashed', padding: '50px' }}>
            <NoPhotos />
        </div>
    );
};
