import React, { useEffect } from 'react';

import ImageError from 'components/ui/Image/ImageError';

import styles from 'components/ui/Image/index.css';

export interface IImageProps {
    src: string | null;
    withError?: boolean | null;
    onClick?: () => void;
}

export default function Image(props: IImageProps) {
    let { src, withError, onClick } = props;
    let [imgSrc, setSrc] = React.useState(src);
    let [isLoading, setLoading] = React.useState(true);
    let [error, setError] = React.useState(withError);

    useEffect(() => {
        setError(null);
        setLoading(!!imgSrc);
    }, [imgSrc]);

    const onLoad = () => {
        setLoading(false);
        setError(null);
    };

    const onError = (error) => {
        setLoading(false);
        setError(error);
    };
    const click = () => {
        if (error) {
            setSrc(imgSrc + `?_timestamp=${new Date().getTime()}`);
        } else {
            onClick?.();
        }
    };

    return (
        <div
            className={`${styles.image_container} ` + `${isLoading ? styles.isLoading : null} `}
            onClick={click}
        >
            <div className={`${styles.gradient} ${isLoading ? styles.gradient_visible : null}`} />
            {error && <ImageError error={error} />}
            {src && !error ? (
                <img
                    src={imgSrc || ''}
                    onLoad={onLoad}
                    onError={onError}
                    className={`${styles.image} ${(!isLoading && !error && styles.loaded) || ''}`}
                />
            ) : null}
        </div>
    );
}
