import * as React from 'react';

import { Input } from 'components/ui/Input/index';

export default { title: 'Input', component: Input };

const Template = ([props, message]) => {
    let [value, onChange] = React.useState(message);

    return (
        <Input
            onChange={(data) => onChange(data)}
            value={value}
            label="Input Text"
            {...props}
        />
    );
};

export const _default_empty = Template.bind({}, [{}, '']);

export const _default_full = Template.bind({}, [{}, 'Message']);

export const _hover_empty = Template.bind({}, [{}, '']);

export const _hover_full = Template.bind({}, [{}, 'Message']);
_hover_empty.parameters = { pseudo: { hover: true } };
_hover_full.parameters = { pseudo: { hover: true } };

export const _focus_empty = Template.bind({}, [{}, '']);

export const _focus_full = Template.bind({}, [{}, 'Message']);

_focus_empty.parameters = { pseudo: { focus: true } };
_focus_full.parameters = { pseudo: { focus: true } };

export const _disabled_empty = Template.bind({}, [{ disabled: true }, '']);

export const _disabled_full = Template.bind({}, [{ disabled: true }, 'Message']);

export const _error_empty = Template.bind({}, [{ error: 'Oh no :((((((((((((((((((' }, '']);

export const _error_full = Template.bind({}, [{ error: 'Oh no :((((((((((((((((((' }, 'Message']);

export const _hover_error_empty = Template.bind({}, [{ error: 'Oh no :((((((((((((((((((' }, '']);

export const _hover_error_full = Template.bind({}, [{ error: 'Oh no :((((((((((((((((((' }, 'Message']);

_hover_error_empty.parameters = { pseudo: { hover: true } };
_hover_error_full.parameters = { pseudo: { hover: true } };

export const _focus_error_empty = Template.bind({}, [{ error: 'Oh no :((((((((((((((((((' }, '']);

export const _focus_error_full = Template.bind({}, [{ error: 'Oh no :((((((((((((((((((' }, 'Message']);

_focus_error_empty.parameters = { pseudo: { focus: true } };
_focus_error_full.parameters = { pseudo: { focus: true } };

export const _error_long_message = Template.bind({}, [
    {
        error: 'Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :((((((((((((((((((Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :(((((((((((((((((( Oh no :((((((((((((((((((',
    },
    'Message',
]);

export const _small_empty = Template.bind({}, [
    {
        small: true,
    },
    '',
]);

export const _small_full = Template.bind({}, [
    {
        small: true,
    },
    'Message',
]);

export const _small_error = Template.bind({}, [
    {
        error: 'Oh no :((((((((((((((((((',
        small: true,
    },
    'Message',
]);
