import React from 'react';

import style from 'components/ui/Input/index.css';

interface IInputProps {
    value: string | number | undefined;
    label?: string;
    onChange: (value: string) => void;
    disabled?: boolean;
    error?: string;
    required?: boolean;
    measure?: string;
    small?: boolean;
}

export const Input = (props: IInputProps) => {
    let { label, value, onChange, disabled, error, required, measure, small } = props;
    let ref = React.useRef<HTMLInputElement>(null);
    let [isInputFull, setInputFull] = React.useState(false);

    React.useEffect(() => {
        setInputFull(value ? value?.toString()?.length > 0 : false);
    }, [value]);

    return (
        <div className={style.input_container}>
            <label>
                <input
                    ref={ref}
                    required={required}
                    disabled={disabled}
                    className={
                        `${style.input}` +
                        ` ${small ? style.input_small : ''}` +
                        ` ${measure ? style.with_measure : ''}` +
                        ` ${isInputFull ? style.input_full : ''}` +
                        ` ${error ? style.input_error : ''}` +
                        ` ${disabled ? style.input_disabled : ''}`
                    }
                    value={value}
                    onChange={(event) => {
                        onChange?.(event.target.value);
                    }}
                />
                {measure ? <span className={style.measure}>{measure}</span> : null}
                {!small ? (
                    <span className={style.input_label}>
                        {label}
                        {required ? <span className={style.required_icon}>*</span> : null}
                    </span>
                ) : null}
                <span className={style.error_description}>{error}</span>
            </label>
        </div>
    );
};
