import * as React from 'react';
import { Story } from '@storybook/react';

import { Label, LabelTextStyle } from 'components/ui/Label/index';

import style from 'components/ui/Label/index.story.css';

export default { title: 'Label', component: Label };

const Template: Story<any> = (props) => <Label {...props} />;

export const no_indicator = Template.bind({});
no_indicator.args = {
    title: 'With title',
};

export const indicator = Template.bind({});
indicator.args = {
    title: 'With title',
    indicator: true,
};

export const indicator_background = Template.bind({});
indicator_background.args = {
    title: 'With title',
    indicator: true,
    background: true,
};

export const colored_indicator = Template.bind({});
colored_indicator.args = {
    title: 'With title',
    indicator: { className: style.color_indicator },
};

export const colored_indicator_background = Template.bind({});
colored_indicator_background.args = {
    title: 'With title',
    indicator: { className: style.color_indicator },
    background: true,
};

export const text_style_subhead = Template.bind({});
text_style_subhead.args = {
    title: 'With title',
    textStyle: LabelTextStyle.SUBHEAD,
};

export const text_style_subhead_background = Template.bind({});
text_style_subhead_background.args = {
    title: 'With title',
    textStyle: LabelTextStyle.SUBHEAD,
    background: true,
};

export const text_style_uppercase = Template.bind({});
text_style_uppercase.args = {
    title: 'With title',
    textStyle: LabelTextStyle.UPPERCASE,
};

export const text_style_uppercase_background = Template.bind({});
text_style_uppercase_background.args = {
    title: 'With title',
    textStyle: LabelTextStyle.UPPERCASE,
    background: true,
};

export const highContainer = () => (
    <div style={{ height: '5em', border: '1px solid black' }}>
        <Label
            background
            title="With title"
        />
    </div>
);

export const narrowContainer = () => (
    <div style={{ width: '10px', border: '1px solid black' }}>
        <Label
            background
            title="With title"
        />
    </div>
);
