import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import Indicator from 'components/ui/Label/indicator.component.svg';

import style from 'components/ui/Label/index.css';

export enum LabelIndicatorTypes {
    NORMAL = 'normal',
    POSITIVE = 'positive',
    WARNING = 'warning',
    ERROR = 'error',
}

export enum LabelTextStyle {
    TEXT = 'text',
    SUBHEAD = 'subhead',
    UPPERCASE = 'uppercase',
}

interface ILabelIndicator {
    className?: string;
    type?: LabelIndicatorTypes;
}

interface ILabelProps {
    title: string;
    background?: boolean;
    textStyle?: LabelTextStyle;
    textClassName?: string;
    bgClassName?: string;
    indicator?: boolean | ILabelIndicator;
}

export const Label = (props: ILabelProps) => {
    let { title, background, indicator, textClassName, textStyle = LabelTextStyle.TEXT, bgClassName } = props;

    return (
        <div className={`${style.label} ${background ? style.background : ''} ${bgClassName || ''}`}>
            {indicator ? (
                <Indicator
                    className={`${style.indicator} ${
                        typeof indicator === 'object'
                            ? indicator.className
                                ? indicator.className
                                : indicator.type
                                ? style[indicator.type]
                                : ''
                            : ''
                    }`}
                />
            ) : null}
            <div className={`${style.title} ${style[textStyle] ?? ''} ${textClassName ?? ''}`}>
                {title || EMPTY_DATA}
            </div>
        </div>
    );
};
