import * as React from 'react';
import { Story } from '@storybook/react';

import { Modal } from 'components/ui/Modal/index';
import Header1 from 'components/ui/Text/Header1';

const MOCK_TITLE = 'Modal title';

export default { title: 'UI/Modal' };

const Template: Story<any> = (args) => <Modal {...args} />;

export const Empty = Template.bind({});
Empty.args = {};

export const With_Title = Template.bind({});
With_Title.args = { title: MOCK_TITLE };

export const With_Content = Template.bind({});
With_Content.args = { title: MOCK_TITLE, contentComponent: <Header1>Content</Header1> };

export const With_Long_Content = Template.bind({});
With_Long_Content.args = {
    title: MOCK_TITLE,
    contentComponent: (
        <div
            style={{
                width: '100%',
                height: '100vh',
                margin: '16px 0',
                background: 'red',
            }}
        />
    ),
};
