import React from 'react';
import ReactDOM from 'react-dom';

import Header4 from 'components/ui/Text/Header4';
import Widget from 'components/ui/Widget';

import style from 'components/ui/Modal/index.css';

interface IModalProps {
    onClose: () => void;
    title?: string;
    contentComponent: any;
}

export const Modal = (props: IModalProps) => {
    let { onClose, title, contentComponent } = props;

    const onClick = () => {
        onClose();
    };

    const header = (
        <div className={style.modal_header}>
            <Header4>{title}</Header4>
            <div
                className={style.close_button}
                onClick={onClick}
            />
        </div>
    );

    const content = <div className={style.modal_content}>{contentComponent}</div>;

    return ReactDOM.createPortal(
        <div className={style.modal_container}>
            <div
                className={style.overlay}
                onClick={onClick}
            />
            <div className={style.content_container}>
                <Widget
                    headerComponent={header}
                    contentComponent={content}
                />
            </div>
        </div>,
        document.body as Element,
    );
};
