import React from 'react';

import styles from 'components/ui/OverlayContainer/index.css';

interface IOverlayContainerProps {
    onClose: () => void;
    zIndex?: OverlayIndex;
}

export enum OverlayIndex {
    sidebar = '16',
    gallery = '17',
}

export default function OverlayContainer(props: IOverlayContainerProps) {
    return (
        <div
            className={styles.overlay_container}
            onClick={props.onClose}
            style={{ '--index': `${props.zIndex}` } as any}
        />
    );
}
