import * as React from 'react';
import { storiesOf } from '@storybook/react';

import { RadioButton } from 'components/ui/RadioButton/index';

const MOCK_VALUE_1 = 'value1';
const MOCK_VALUE_2 = 'value2';
const MOCK_VALUE_3 = 'value3';
const MOCK_VALUE_1_OBJ = { value: MOCK_VALUE_1, placeholder: MOCK_VALUE_1 };
const MOCK_VALUE_2_OBJ = { value: MOCK_VALUE_2, placeholder: MOCK_VALUE_2 };
const MOCK_VALUE_3_OBJ = { value: MOCK_VALUE_3, placeholder: MOCK_VALUE_3 };

storiesOf('RadioButton', module)
    .add('empty', () => (
        <RadioButton
            onChange={() => {}}
            values={[]}
        />
    ))
    .add('one unselected value, selected automatically', () => (
        <RadioButton
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ]}
        />
    ))
    .add('one selected value', () => (
        <RadioButton
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ]}
            selectedValue={MOCK_VALUE_1}
        />
    ))
    .add('one unselected value with odd selectedValue, selected automatically', () => (
        <RadioButton
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ]}
            selectedValue="odd_value"
        />
    ))
    .add('two unselected values, selected automatically', () => (
        <RadioButton
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ]}
        />
    ))
    .add('two values, second is selected', () => (
        <RadioButton
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ]}
            selectedValue={MOCK_VALUE_2}
        />
    ))
    .add('three unselected values, selected automatically', () => (
        <RadioButton
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ, MOCK_VALUE_3_OBJ]}
        />
    ))
    .add('secondary', () => (
        <RadioButton
            secondary
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ]}
            selectedValue={MOCK_VALUE_1}
        />
    ))
    .add('mini two values', () => (
        <RadioButton
            mini
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ]}
            selectedValue={MOCK_VALUE_1}
        />
    ))
    .add('mini three values', () => (
        <RadioButton
            mini
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ, MOCK_VALUE_3_OBJ]}
            selectedValue={MOCK_VALUE_1}
        />
    ))
    .add('secondary full with 2 buttons', () => (
        <RadioButton
            secondary
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ]}
            fullWidth
            selectedValue={MOCK_VALUE_1}
        />
    ))
    .add('secondary full with 3 buttons', () => (
        <RadioButton
            secondary
            onChange={() => {}}
            values={[MOCK_VALUE_1_OBJ, MOCK_VALUE_2_OBJ, MOCK_VALUE_3_OBJ]}
            fullWidth
            selectedValue={MOCK_VALUE_1}
        />
    ));
