import * as React from 'react';
import { Story } from '@storybook/react';

import { ScoringLabel, ScoringLabelTypes } from 'components/ui/ScoringLabel/index';

export default { title: 'ScoringLabel', component: ScoringLabel };

const Template: Story<any> = (props) => <ScoringLabel {...props} />;

export const positive = Template.bind({});
positive.args = {
    title: 'With title',
    type: ScoringLabelTypes.positive,
};

export const warning = Template.bind({});
warning.args = {
    title: 'With title',
    type: ScoringLabelTypes.warning,
};

export const negative = Template.bind({});
negative.args = {
    title: 'With title',
    type: ScoringLabelTypes.negative,
};

export const positive_with_score = Template.bind({});
positive_with_score.args = {
    title: 'With title',
    type: ScoringLabelTypes.negative,
    score: 6.6,
};

export const negative_with_score = Template.bind({});
negative_with_score.args = {
    title: 'With title',
    type: ScoringLabelTypes.negative,
    score: 1,
};

export const warning_with_score = Template.bind({});
warning_with_score.args = {
    title: 'With title',
    type: ScoringLabelTypes.negative,
    score: 0.5,
};

export const unknown_with_score = Template.bind({});
unknown_with_score.args = {
    title: 'With title',
    type: ScoringLabelTypes.unknown,
    score: '-',
};
