import * as React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import style from 'components/ui/ScoringLabel/index.css';

export enum ScoringLabelTypes {
    positive = 'positive',
    warning = 'warning',
    negative = 'negative',
    unknown = 'unknown',
}

interface IScoringLabelProps {
    title: string;
    score?: string | number;
    type: ScoringLabelTypes;
}

export const ScoringLabel = (props: IScoringLabelProps) => {
    let { title, type, score } = props;

    return (
        <div className={`${style.label} ${style[type]}`}>
            <span className={`${style.title}`}>{title ?? EMPTY_DATA}</span>
            {score !== undefined ? <span className={`${style.score}`}>{score}</span> : null}
        </div>
    );
};
