import * as React from 'react';

import styles from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton/MetaControlOption/index.css';

interface IMetaControlOptionItemProps {
    Icon: any;
    title: string;
    onClick: () => void;
    additionalText?: string;
}

export const MetaControlOptionItem = (props: IMetaControlOptionItemProps) => {
    let { Icon, title, onClick, additionalText } = props;

    return (
        <div
            className={styles.meta_control_item}
            onClick={onClick}
        >
            <span className={styles.icon}>
                <Icon />
            </span>
            <span className={styles.meta_control_label}>
                <span>{title}</span>
                {additionalText ? <span className={styles.additional_text}>{additionalText}</span> : null}
            </span>
        </div>
    );
};
