import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add to group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add to group',
        ru: 'Добавить в группу',
        cs: 'Přidat do skupiny',
    },
    'Failed to load XLSX': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Failed to load XLSX',
        ru: 'Не удалось загрузить XLSX',
        cs: 'Načtení XLSX se nezdařilo',
    },
    'Go to Groups section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Go to Groups section',
        ru: 'Перейти в раздел «Группы»',
        cs: 'Přejít do části Skupiny',
    },
    'Group created': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Group created',
        ru: 'Группа создана',
        cs: 'Skupina vytvořena',
    },
    Save: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Save',
        ru: 'Сохранить',
        cs: 'Uložit',
    },
    'Save as report': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save as report',
        ru: 'Сохранить как отчет',
        cs: 'Uložit jako výkaz',
    },
    'Try again': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Try again',
        ru: 'Попробовать снова',
        cs: 'Zkuste to znovu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
