import { RequestHelperConfigs, RequestHelperMethod } from '../../../../../../../request-helper/src';

enum REQUESTS {
    GET_CARS = 'GET_CARS',
    GET_CAR_SESSIONS = 'GET_CAR_SESSIONS',
    GET_TAXI_PARKS = 'GET_TAXI_PARKS',
    GET_TRACE = 'GET_TRACE',
    GET_CAR_TELEMATICS = 'GET_CAR_TELEMATICS',
    AREAS_INFO = 'AREAS_INFO',
    TRACE_TAGS = 'TRACE_TAGS',
    GET_TELEMATICS_HISTORY = 'GET_TELEMATICS_HISTORY',
    EDIT_CAR = 'EDIT_CAR',
    GET_SETTINGS = 'GET_SETTINGS',
}

const SAVE_REPORT_REQUESTS: RequestHelperConfigs = {
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            page_number: null,
            page_size: null,
            tags_filter: null,
            no_sh: null,
            no_mileage: null,
            sla: null,
            fines: null,
            cars_type: null,
            sensors: null,
            car_id: null,
            traits: null,
            sort: null,
            order_field: null,
            order_desc: null,
        },
    },
    [REQUESTS.GET_CAR_SESSIONS]: {
        api: 'sessions/history2',
        cgiObj: {
            car_id: null,
            session_id: null,
            since: null,
            until: null,
            numdoc: null,
            traits: null,
        },
    },
    [REQUESTS.GET_TRACE]: {
        api: 'track/analyzer',
        cgiObj: {
            session_id: null,
            speed_threshold: null,
            length_threshold: null,
        },
    },
    [REQUESTS.GET_TAXI_PARKS]: {
        api: 'taxi_companies/list',
        method: RequestHelperMethod.POST,
        cgiObj: {
            page_size: null,
            page_number: null,
        },
    },
    [REQUESTS.GET_CAR_TELEMATICS]: {
        api: 'car/telematics/state',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.AREAS_INFO]: {
        api: 'areas/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.TRACE_TAGS]: {
        api: 'trace/tag/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_TELEMATICS_HISTORY]: {
        api: 'car/telematics/history',
        cgiObj: {
            car_id: null,
            source: 'ch',
            since: null,
            until: null,
            sensor_id: null,
        },
    },
    [REQUESTS.EDIT_CAR]: {
        api: 'car/edit',
        method: RequestHelperMethod.POST,
    },
    [REQUESTS.GET_SETTINGS]: {
        api: 'settings/get',
        cgiObj: {
            fields: null,
        },
    },
};

export { SAVE_REPORT_REQUESTS, REQUESTS };
