import React, { useState } from 'react';
import { useHistory, useLocation } from 'react-router-dom';

import { ReportSection } from 'entities/Report/consts/ReportSection';

import ReportModal from 'components/Reports/ReportModal';
import { MetaControlTypes } from 'components/types';
import ControlButton, { ButtonSize } from 'components/ui/Buttons/ControlButton';
import { MetaControlSave } from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton/MetaControlSave';

import { i18n } from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton/index.i18n';

import Clear from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton/clear.component.svg';

import style from 'components/ui/SectionLayout/SectionFiltersSidebar/MetaControlButton/index.css';

interface IMetaControlButtonProps {
    onClick?: () => void;
    type: MetaControlTypes;
    disabled?: boolean;
    filterValues?: any;
    section?: ReportSection;
    getData?: (options: any) => void;
    abortGettingData?: () => void;
    xlsxLabel?: string;
    tagsFilter?: string | null;
}

const MetaControlButton = ({
    onClick: onClickProps,
    type,
    disabled,
    filterValues,
    section,
    abortGettingData,
    getData,
    xlsxLabel,
    tagsFilter,
}: IMetaControlButtonProps) => {
    const [isReportModalOpen, setIsReportModalOpen] = useState<boolean>(false);
    let history = useHistory();
    let location = useLocation();

    let component;

    const onClearDefaultClick = () => {
        history.push(location.pathname);
    };

    const onSaveDefaultClick = () => {
        setIsReportModalOpen(true);
    };

    const onCloseReportModalClick = () => {
        setIsReportModalOpen(false);
    };

    switch (type) {
        case MetaControlTypes.clear:
            component = (
                <ControlButton
                    fullWidth
                    size={ButtonSize.M}
                    leftAlign
                    tertiary
                    disabled={disabled}
                    title={
                        <>
                            <Clear />
                            {i18n('Clear')}
                        </>
                    }
                    onClick={onClickProps ?? onClearDefaultClick}
                />
            );

            break;
        case MetaControlTypes.save:
            component = (
                <MetaControlSave
                    abortGettingData={abortGettingData}
                    getData={getData}
                    xlsxLabel={xlsxLabel}
                    section={section}
                    disabled={disabled}
                    onClickProps={onClickProps ?? onSaveDefaultClick}
                    tagsFilter={tagsFilter}
                />
            );

            break;
    }

    return (
        <div className={style.meta_control_container}>
            {component}
            {isReportModalOpen ? (
                <ReportModal
                    onClose={onCloseReportModalClick}
                    section={section as ReportSection}
                    filterValues={filterValues}
                />
            ) : null}
        </div>
    );
};

export default MetaControlButton;
